unit OnShowHint;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Buttons, ExtCtrls;

type
  TForm1 = class(TForm)
    Panel1: TPanel;
    SpeedButton1: TSpeedButton;
    SpeedButton2: TSpeedButton;
    SpeedButton3: TSpeedButton;
    procedure FormCreate(Sender: TObject);
   private
    { Private declarations }
  public
    procedure DoShowHint(var HintStr: String; var CanShow: Boolean; var HintInfo: THintInfo);
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: OnShowHint
// Event: Forms.TApplication.OnShowHint
// Type: Forms.THintInfo

// BeginCode
{
This example uses three speed buttons on a panel. The code 
changes the color, width, and position of the text in the 
Help Hint for the third speed button. Set the ShowHint 
property of each speed button to true and give a value to 
the Hint property of each.  You must declare the DoShow 
method in the type declaration of the form. Once it is 
declared, write the code for the DoShow method in the 
implementation part of the unit. Finally, in the OnCreate 
event handler for the form, assign the method to the 
OnShowHint event of the application.
} 

procedure TForm1.DoShowHint(var HintStr: String; var CanShow: Boolean; var HintInfo: THintInfo);
begin
  if HintInfo.HintControl = SpeedButton3 then
  begin
    with HintInfo do
    begin
      HintColor := clAqua;{ Changes only for this hint }
      HintMaxWidth := 120;{Hint text word wraps if width is greater than 120 }
      Inc(HintPos.X, SpeedButton3.Width); { Move hint to right edge }
    end;
  end;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  Application.ShowHint := True;
  Application.OnShowHint := DoShowHint;
end;
// EndCode
// EndExample: OnShowHint
end.
