unit TAppRestore;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls;

type
  TForm1 = class(TForm)
    Timer1: TTimer;
    procedure FormCreate(Sender: TObject);
    procedure AppStartTimer(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: TApplicationRestore
// Method: Forms.TApplication.Restore
// Event: Forms.TApplication.OnMinimize
// Property: ExtCtrls.TTimer.Enabled
// Property: ExtCtrls.TTimer.Interval

// BeginCode
{
This example uses a timer on a form. When the application
runs and the user minimizes the application, the timer
starts and the application returns to its normal size when
an OnTimer event occurs.  The timer then shuts down until
the next time the form is minimized.  Be sure to declare the
AppStartTimer method as a public method of TForm1.  Place a
TTimer object in the form and enter Timer1Timer in the OnTimer
event.
}
procedure TForm1.FormCreate(Sender: TObject);
begin
  Application.OnMinimize := AppStartTimer;
end;

procedure TForm1.AppStartTimer(Sender: TObject);
begin
  Timer1.Enabled := True;
end;

procedure TForm1.Timer1Timer(Sender: TObject);
begin
  Application.Restore;
  Timer1.Enabled := False;
end; 
// EndCode
// EndExample: TApplicationRestore
end.
