unit TAppIcon;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtDlgs;

type
  TForm1 = class(TForm)
    OpenPictureDialog1: TOpenPictureDialog;
    Button1: TButton;
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: TApplicationIcon
// Property: Forms.TApplication.Icon
// Property: Dialogs.TOpenDialog.DefaultExt
// Property: Dialogs.TOpenDialog.FileName
// Property: Dialogs.TOpenDialog.Filter
// Property: Dialogs.TOpenDialog.Options
// Method: Dialogs.TOpenDialog.Execute
// Routine: Graphics.GraphicFileMask
// Type: Dialogs.TOpenOptions

// Warning: Removing ofExtensionDifferent from the Options list did not work.  Commented out.

// BeginCode
{
The following code allows the user to use a dialog box to
redefine the icon for the application at run time. When the
user clicks Button1, OpenDialog1 executes and the user
specifies an icon filename. The Icon is then assigned to the
application.  At runtime, click Button1 to select the icon,
then minimize the application to see the icon.
}
procedure TForm1.Button1Click(Sender: TObject);
var 
Done: Boolean;
filenamestring : String;
begin
  OpenPictureDialog1.DefaultExt := GraphicExtension(TIcon);
  filenamestring := GraphicFileMask(TIcon);
  OpenPictureDialog1.FileName := filenamestring;
  OpenPictureDialog1.Filter := GraphicFilter(TIcon);
  OpenPictureDialog1.Options := [ ofFileMustExist, ofHideReadOnly, ofNoChangeDir ];
  Done := False;
  while not Done do
  begin
  if OpenPictureDialog1.Execute then
    begin
    if not (ofExtensionDifferent in OpenPictureDialog1.Options) then
      begin
      Application.Icon.LoadFromFile(OpenPictureDialog1.FileName);
      Done := True;
      end
    else
//      OpenPictureDialog1.Options := OpenPictureDialog1.Options - ofExtensionDifferent;
    end
  else { User cancelled }
    Done := True;
  end;
end; 
// EndCode
// EndExample: TApplicationIcon
end.
