{
The following code allows the user to use a dialog box to redefine the icon for the application at run time. When the user clicks Button1, OpenDialog1 executes and the user specifies an icon filename. The Icon is then assigned to the application.
} 
procedure TForm1.Button1Click(Sender: TObject);
var 
Done: Boolean;
begin
  OpenPictureDialog1.DefaultExt := GraphicExtension(TIcon);
  OpenPictureDialog1.FileName := GraphicFileMask(TIcon);
  OpenPictureDialog1.Filter := GraphicFilter(TIcon);
  OpenPictureDialog1.Options := [ofFileMustExist, ofHideReadOnly, ofNoChangeDir ];
  while not Done do
  begin
  if OpenPictureDialog1.Execute then
    begin
    if not (ofExtensionDifferent in OpenPictureDialog1.Options) then
      begin
      Application.Icon.LoadFromFile(OpenPictureDialog1.FileName);
      Done := True;
      end
    else
      OpenPictureDialog1.Options := OpenPictureDialog1.Options - ofExtensionDifferent;
    end
  else { User cancelled }
    Done := True;
  end;
end; 
