unit ButtonedEdit;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, StdCtrls;

// BeginExample: TButtonedEdit
// Class: ExtCtrls.TButtonedEdit
// Class: ExtCtrls.TEditButton
// Property: ExtCtrls.TCustomButtonedEdit.LeftButton
// Property: ExtCtrls.TCustomButtonedEdit.RightButton
// Property: ExtCtrls.TCustomButtonedEdit.Images
// Event: ExtCtrls.TCustomButtonedEdit.OnLeftButtonClick
// Event: ExtCtrls.TCustomButtonedEdit.OnRightButtonClick
// Property: ExtCtrls.TEditButton.Enabled
// Property: ExtCtrls.TEditButton.ImageIndex
// Property: ExtCtrls.TEditButton.DisabledImageIndex
// Property: ExtCtrls.TEditButton.HotImageIndex

// BeginCode
{
This example shows how to use the TButtonedEdit class. This example
implements a component like "TButtonedEdit search" that's to be
found in the tool pallete window.
Entering the control will enable the right button, left button will
display a MessageDlg and the right button will clear the input text.
}
type
  TForm4 = class(TForm)
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
    btnEdit : TButtonedEdit;
    procedure btnEditEnter(Sender : Tobject);
    procedure btnEditLeftClick(Sender : Tobject);
    procedure btnEditRightClick(Sender : Tobject);
  public
    { Public declarations }
  end;

var
  Form4: TForm4;

implementation

{$R *.dfm}

procedure TForm4.btnEditEnter(Sender: Tobject);
begin
  btnEdit.Text := '';
  btnEdit.RightButton.Visible := true;
end;

procedure TForm4.btnEditLeftClick(Sender: Tobject);
begin
  MessageDlg('Left button pressed with: ' + btnEdit.Text,
  			 mtInformation, [mbYes], 0);

end;

procedure TForm4.btnEditRightClick(Sender: Tobject);
begin
  //resetting to default state
   btnEdit.Text := 'Default';
   btnEdit.RightButton.Visible := false;
end;

procedure TForm4.FormCreate(Sender: TObject);
var
  imList : TImageList;
  bmap   : TBitmap;
begin
  //declaring an instance
	btnEdit := TButtonedEdit.Create(Self);

	//setting the parent so it will autodetele
	btnEdit.Parent := Self;

	//positioning
	btnEdit.Left := 10;
	btnEdit.Top := 10;

	//creating a TImageList and using it for the button
	imList := TImageList.Create(Self);
	bmap := TBitmap.Create();
	bmap.LoadFromFile('littleB_16.bmp');
	imList.Add(bmap,nil);
	bmap.LoadFromFile('little_logo_16.bmp');
	imList.Add(bmap,nil);
	btnEdit.Images := imList;

	//selecting the image for the left button and enabling it
	btnEdit.LeftButton.Visible := true;
	btnEdit.LeftButton.Enabled := true;
	btnEdit.LeftButton.ImageIndex := 0;
	btnEdit.LeftButton.DisabledImageIndex := 0;
	btnEdit.LeftButton.HotImageIndex := 0;

	//selecting the image for the right button
	//this will be enabled when the content changes
	btnEdit.RightButton.Enabled := true;
	btnEdit.RightButton.ImageIndex := 1;
	btnEdit.RightButton.DisabledImageIndex := 1;
	btnEdit.RightButton.HotImageIndex := 1;

	//selecting action for the buttoned edit to take
	btnEdit.OnEnter := btnEditEnter;
	btnEdit.OnRightButtonClick := btnEditRightClick;
	btnEdit.OnLeftButtonClick := btnEditLeftClick;

	//default text in the edit
	btnEdit.Text := 'Default';

	btnEdit.Constraints.MinHeight := 16;
	btnEdit.Height := 16;

	//finally displaying the button
	btnEdit.Show();

end;

// EndCode
// EndExample: TButtonedEdit

end.
