unit TControlCursor;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

type
  TForm1 = class(TForm)
    Button2: TButton;
    procedure Button2Click(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: TControlCursor
// Property: Controls.TControl.Cursor
// Property: Forms.TScreen.Cursors
// Property: Forms.TScreen.Cursor
// Property: Graphics.TBitmap.Handle

// BeginCode
{
This example shows how to add custom cursors to an
application.  The following code makes this cursor available
to the application via the constant crMyCursor, and sets it
as the global cursor to the application.
} 
var
  bmpMask : TBitmap;
  bmpColor : TBitmap;
  iconInfo : TIconInfo;
const
  crMyCursor = 5;

procedure TForm1.Button2Click(Sender: TObject);
begin
  bmpMask := TBitmap.Create;
  bmpColor := TBitmap.Create;

  bmpMask.LoadFromFile('SquareMask.bmp');
  bmpColor.LoadFromFile('Square.bmp');

  with iconInfo do
  begin
    fIcon := false;
    xHotspot := 15;
    yHotspot := 15;
    hbmMask := bmpMask.Handle;
    hbmColor := bmpColor.Handle;
  end;

  Screen.Cursors[crMyCursor] := CreateIconIndirect(iconInfo);
  
  Screen.Cursor := crMyCursor;

  bmpMask.Free;
  bmpColor.Free;
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
  DestroyIcon(Screen.Cursors[crMyCursor]);
end;
// EndCode
// EndExample: TControlCursor
end.
