unit TControlParent;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

type
  TForm1 = class(TForm)
    GroupBox1: TGroupBox;
    Button1: TButton;
    Button2: TButton;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: TControlParent
// Method: Controls.TControl.Parent
// Method: Controls.TWinControl.InsertControl
// Method: Controls.TWinControl.RemoveControl

// BeginCode
{
This example uses a button placed next to a group box. When the
user clicks the button, the group box becomes the parent of the
button, so the button moves inside the group box.
} 
procedure TForm1.Button1Click(Sender: TObject);
begin
  if (Button1.Parent <> GroupBox1) then // second click?
  begin
    RemoveControl(Button1);
    GroupBox1.InsertControl(Button1);
  end;
end;

{
Note that it was necessary to remove the button from the Controls
property of the form before the button actually moves into the
group box. This code accomplishes the same thing:
}

procedure TForm1.Button2Click(Sender: TObject);
begin
  Button2.Parent := GroupBox1;
end;
// EndCode
// EndExample: TControlParent
end.
