unit TControlPerform;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ComCtrls, Mask;

type
  TForm1 = class(TForm)
    RichEdit1: TRichEdit;
    Button1: TButton;
    MaskEdit1: TMaskEdit;
    Edit1: TEdit;
    Label1: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure RichEdit1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: TControlPerform
// Method: Controls.TControl.Perform
// Method: Controls.TWinControl.SetFocus

// Warning: Could use a check for integer for MaskEdit1 instead of breaking.

// BeginCode
{
The following example demonstrates the use of the Perform method
to send a windows message. The EM_SCROLLCARET message scrolls the
caret in the rich edit into view. The caret position is set to the
contents of the mask edit prior to calling Perform.
}
procedure TForm1.Button1Click(Sender: TObject);
begin
with RichEdit1 do
  Begin
    SelStart := StrToInt(MaskEdit1.Text);
    Edit1.Text := InttoStr(SelStart);
    RichEdit1.Perform(EM_SCROLLCARET, 0, 0);
    RichEdit1.SetFocus;
  end;
end;
// EndCode
// EndExample: TControlPerform

procedure TForm1.FormCreate(Sender: TObject);
const
  Path = 'overview.rtf';
begin
  RichEdit1.PlainText := False;
  RichEdit1.Lines.LoadFromFile(Path);
  Edit1.ReadOnly := True;
  Edit1.Text := '0';
end;

procedure TForm1.RichEdit1Click(Sender: TObject);
begin
  Edit1.Text := InttoStr(RichEdit1.SelStart);
end;

end.
