unit TControlTop;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ComCtrls, StdCtrls;

type
  TForm1 = class(TForm)
    UpDown1: TUpDown;
    GroupBox1: TGroupBox;
    TabControl1: TTabControl;
    HeaderControl1: THeaderControl;
    PageControl1: TPageControl;
    procedure UpDown1Click(Sender: TObject; Button: TUDBtnType);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: TControlTop
// Property: Controls.TWinControl.ControlCount
// Property: Controls.TWinControl.Controls
// Property: Controls.TControl.Top

// BeginCode
{
This example uses an updown control and a group box on a 
form, with several controls contained within the group box.
When the updown control is clicked, the controls within 
the group box are moved in the appropriate direction.
}
procedure TForm1.FormCreate(Sender: TObject);
var
  I: Integer;
const
  colorarray : Array[0..4] of TColor = (clYellow, clGreen, clBlue, clLime, clFuchsia);
begin
   GroupBox1.Brush.Color := clRed;
  for I:= 0 to GroupBox1.ControlCount -1 do
  begin
    TWinControl(GroupBox1.Controls[I]).Brush.Color := colorarray[I];
  end;
end;

procedure TForm1.UpDown1Click(Sender: TObject; Button: TUDBtnType);
var
  I: Integer;
  ChildControl: TControl;
begin
  for I:= 0 to GroupBox1.ControlCount -1 do
  begin
    ChildControl := GroupBox1.Controls[I];
    if Button = btNext then
      ChildControl.Top := ChildControl.Top + 15
    else
      ChildControl.Top := ChildControl.Top - 15;
  end;
end;
// EndCode
// EndExample: TControlTop
end.
