unit TCoolBarBands;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ComCtrls, StdCtrls;

type
  TForm1 = class(TForm)
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: TCoolBarBands
// Property: ComCtrls.TCoolBar.Bands
// Property: ComCtrls.TCoolBands.Items
// Property: ComCtrls.TCoolBand.Text
// Method: ComCtrls.TCoolBar.Create
// Type: Controls.TControlClass

// BeginCode
{
To run this example, add the example code to a new project.
The example code dynamically creates a TCoolBar and three
TCoolBand objects populated with a windowed control in each
TCoolBand.
}
procedure AddBand(CoolBar: TCoolBar; Const ControlClasses: array of TControlClass);
var
  CurrentControl: TControl;
  I: Integer;
begin
  for I := 0 to High(ControlClasses) do
    begin
      CurrentControl := ControlClasses[i].Create(CoolBar);
      if (CurrentControl is TWinControl) then
      begin
        { Placing the control onto the CoolBar causes the TCoolBar object to create a TCoolBand and place the control within the band. }
        CurrentControl.Parent := Coolbar;
        { Get the reference of the last TCoolBand created and assign text. }
        with CoolBar.Bands do
          Items[count - 1].Text := CurrentControl.ClassName;
      end;
    end;
end;

procedure TForm1.FormCreate(Sender: TObject);
var
  CoolBar: TCoolBar;
begin
  CoolBar := TCoolBar.Create(Self);
  CoolBar.Parent := Self;
  CoolBar.Align := alClient;
  AddBand(CoolBar, [TCheckBox, TEdit, TButton]);
end;
// EndCode
// EndExample: TCoolBarBands
end.
