unit TCustomFormCanvas;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

type
  TForm1 = class(TForm)
    Button1: TButton;
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: TCustomFormCanvas
// Property: Forms.TCustomForm.Canvas
// Property: Graphics.TCanvas.Brush
// Property: Graphics.TBrush.Bitmap
// Method: Graphics.TCanvas.FillRect

// BeginCode
{
The following code loads a bitmap from a file and assigns it
to the Brush of the Canvas of Form1:
} 
var
  Bitmap: TBitmap;

procedure TForm1.Button1Click(Sender: TObject);
begin
  Bitmap := TBitmap.Create;
  try
    Bitmap.LoadFromFile('bm1.BMP');
    Form1.Canvas.Brush.Bitmap := Bitmap;
    Form1.Canvas.FillRect(Rect(0,0,100,100));
  finally
    Form1.Canvas.Brush.Bitmap := nil;
    Bitmap.Free;
  end;
end; 
// EndCode
// EndExample: TCustomFormCanvas
end.
