unit TDataSetActive;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, DB, StdCtrls, ExtCtrls, DBCtrls, Grids, DBGrids, DBClient, SwSystem,
  DBTables, ComCtrls;

type
  TForm1 = class(TForm)
    DS2: TDataSource;
    DBGrid2: TDBGrid;
    DBNavigator2: TDBNavigator;
    ProgressBar1: TProgressBar;
    Button1: TButton;
    procedure FormCreate(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
  Customers: TTable;
implementation

{$R *.dfm}

// BeginExample: TDataSetActive
// Property: DBTables.TDBDataSet.DatabaseName
// Property: DB.TDataSet.Active

// BeginCode
{
This example requires a database with the following name or
in the form of a *.DB file in the following path.  The table
should be closed when changing the database.
}
procedure TForm1.Button1Click(Sender: TObject);
begin
  Customers.Active := False;
  try
  { First try to use an alias }
    Customers.DatabaseName := 'DBDEMOS';
    Customers.Active := True;
  except
    on EDatabaseError do
    begin
      { If that fails, try to use the drive and directory }
      Customers.TableName := 'Flights';
      // This path depends on the Demos directory of your RAD Studio installation.
      Customers.DatabaseName :=
        'c:\Documents and Settings\All Users\Documents\RAD Studio\6.0\Demos\IntraWeb\Win32\FlightInformation\Data';
      Customers.Active := True;
    end;
  end;
end;
// EndCode
// EndExample: TDataSetActive

procedure TForm1.FormCreate(Sender: TObject);
var
  i: Integer;
begin
  Customers:= TTable.Create(Form1);
  with Customers do
  begin
    DatabaseName := 'DBDEMOS';
    TableType := ttParadox;
    TableName := 'CustInfo';
    Active := False;
    { Don't overwrite an existing table }
    if not Customers.Exists then
    begin
      { The Table component must not be active }
      { First, describe the type of table and give }
      { it a name }
      { Next, describe the fields in the table }
      with FieldDefs do
      begin
        Clear;
        with AddFieldDef do
        begin
          Name := 'Field1';
          DataType := ftInteger;
          Required := True;
        end;
        with AddFieldDef do
        begin
          Name := 'Field2';
          DataType := ftString;
          Size := 30;
        end;
      end;
      { Next, describe any indexes }
      with IndexDefs do
      begin
        Clear;
        { The 1st index has no name because it is
        { a Paradox primary key }
        with AddIndexDef do
        begin
          Name := '';
          Fields := 'Field1';
          Options := [ixPrimary];
        end;
        with AddIndexDef do
        begin
          Name := 'Fld2Indx';
          Fields := 'Field2';
          Options := [ixCaseInsensitive];
        end;
      end;
      { Call the CreateTable method to create the table }
      CreateTable;
      Customers.Active:= True;
      for i := 1 to 20 do
        Customers.AppendRecord([i*111, i*222]);
      Customers.Close;
    end;
  end;
  DS2.DataSet:= Customers;
  DBGrid2.DataSource.DataSet:= Customers;
end;
end.
