unit TDataSetAppend;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, DB, StdCtrls, ExtCtrls, DBCtrls, Grids, DBGrids, DBClient, SwSystem,
  DBTables, ComCtrls;

type
  TForm1 = class(TForm)
    DS2: TDataSource;
    DBGrid2: TDBGrid;
    DBNavigator2: TDBNavigator;
    Button1: TButton;
    Edit1: TEdit;
    Edit2: TEdit;
    procedure FormCreate(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
  Customers: TTable;
implementation

{$R *.dfm}

// BeginExample: TDataSetAppend
// Method: DB.TDataSet.Append
// Property: DB.TDataSet.FieldValues
// Method: DBClient.TCustomClientDataSet.Post
// Method: DBTables.TBDEDataSet.Post
// Method: DB.TDataSet.Post

// BeginCode
{
This example appends a new record to a table or client
dataset when the user clicks a button. The two fields
Field1 and Field2 are filled from the contents of two edit
controls.  This example requires a populated TTable or
TDataSet with the appropriate field values.
} 
procedure TForm1.Button1Click(Sender: TObject);
begin
  Customers.Append;
  Customers.FieldValues['Field1'] := StrToInt(Edit1.text);
  Customers.FieldValues['Field2'] := Edit2.text;
  Customers.Post;
end;
// EndCode
// EndExample: TDataSetAppend

procedure TForm1.FormCreate(Sender: TObject);
var
  i: Integer;
begin
  Customers:= TTable.Create(Form1);
  with Customers do
  begin
    DatabaseName := 'DBDEMOS';
    TableType := ttParadox;
    TableName := 'CustInfo';
    Active := False;
    { Don't overwrite an existing table }
    if not Customers.Exists then
    begin
      { The Table component must not be active }
      { First, describe the type of table and give }
      { it a name }
      { Next, describe the fields in the table }
      with FieldDefs do
      begin
        Clear;
        with AddFieldDef do
        begin
          Name := 'Field1';
          DataType := ftInteger;
          Required := True;
        end;
        with AddFieldDef do
        begin
          Name := 'Field2';
          DataType := ftString;
          Size := 30;
        end;
      end;
      { Next, describe any indexes }
      with IndexDefs do
      begin
        Clear;
        { The 1st index has no name because it is
        { a Paradox primary key }
        with AddIndexDef do
        begin
          Name := '';
          Fields := 'Field1';
          Options := [ixPrimary];
        end;
        with AddIndexDef do
        begin
          Name := 'Fld2Indx';
          Fields := 'Field2';
          Options := [ixCaseInsensitive];
        end;
      end;
      { Call the CreateTable method to create the table }
      CreateTable;
      Customers.Active:= True;
      for i := 1 to 20 do
        Customers.AppendRecord([i*111, i*222]);
    end;
  end;
  DS2.DataSet:= Customers;
  DBGrid2.DataSource.DataSet:= Customers;
  Customers.Active:= True;
end;
end.
