unit TDataSetBeforeInsert;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, DB, StdCtrls, ExtCtrls, DBCtrls, Grids, DBGrids, DBClient;

type
  TForm1 = class(TForm)
    CDS: TClientDataSet;
    DS: TDataSource;
    DBGrid1: TDBGrid;
    DBNavigator1: TDBNavigator;
    CDSHOST: TStringField;
    CDSPORTA: TIntegerField;
    Button3: TButton;
    Edit1: TEdit;
    procedure Button3Click(Sender: TObject);
    procedure CDSBeforeInsert(DataSet: TDataSet);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: TDataSetBeforeInsert
// Event: DB.TDataSet.BeforeInsert
// Method: DB.TDataSet.Insert
// Property: DB.TField.AsInteger
// Method: DB.TDataSet.FieldByName

// BeginCode
{
This example uses the BeforeInsert event to do data 
validation. If the StrToInt function raises an exception, 
the edit controls contents are set to a valid value so 
that the assignment to the INTEGER field in the dataset 
will succeed.  Continuing after the exception causes a
'0' to be placed in the PORTA field.
DataSet design:
This example requires a ClientDataSet, a DBGrid, a
DataSource and a DBNavigator.  Name the ClientDataSet CDS.
Set the DataSet property in the DataSource to CDS and name
that DataSource DS.  Set the DataSource in the DBNavigator
to DS the DataSource in the DBGrid to DS.  Right click on CDS
and select the Fields Editor, then right click on the Field
Editor form and create two fields by selecting "new field".
In the field configuration window, set the name to HOST, the
Component value will automatically be set to CDSHOST.  Set
the filed type to String.  In the field configuration window
for the second field, set the name to PORTA, the Component
value will automatically be set to CDSPORTA.  Set the field
type to Integer.  The file used to load CDS must have an
attribute name of HOST with an attribute type of string and
an attribute name of PORTA with an attribute type of integer.
Add DB, DBCtrls, Grids, DBGrids and DBClient to the uses clause.
}
{$IFNDEF UNICODE}
uses SwSystem;
{$ENDIF}

procedure TForm1.Button3Click(Sender: TObject);
begin
  CDS.Insert;
  CDS.FieldByName('PORTA').AsInteger := StrToInt(Edit1.Text);
  CDS.Post;
end;

procedure TForm1.CDSBeforeInsert(DataSet: TDataSet);
begin
  try
  { Make sure edit field can be converted to integer --
   this will raise an exception if it cant }
    StrToInt(Edit1.Text);
  except
    Edit1.Text := '0';
  end;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
{$IFDEF UNICODE}
  CDS.LoadFromFile(GetCurrentDir + '\CDS.XML');
{$ELSE}
  CDS.LoadFromFile(gsAppPath + 'CDS.XML');
{$ENDIF}
end;
// EndCode
// EndExample: TDataSetBeforeInsert
end.
