{
This example uses the BeforeInsert event to do data 
validation. If the StrToInt function raises an exception, 
the edit controls contents are set to a valid value so 
that the assignment to the INTEGER field in the dataset 
will succeed.
} 
procedure TForm1.ClientDataSet1BeforeInsert(DataSet: TDataSet);
begin
  try
  { Make sure edit field can be converted to integer --
   this will raise an exception if it cant }
    StrToInt(Edit1.Text);
  except
    Edit1.Text := '0';
  end;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  ClientDataSet1.Insert;
  ClientDataSet1.FieldByName('QUANTITY').AsInteger := StrToInt(Edit1.Text);
  ClientDataSet1.Post;
end; 
