unit TDataSetRefresh;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, DB, StdCtrls, ExtCtrls, DBCtrls, Grids, DBGrids, DBClient, SwSystem,
  DBTables;

type
  TForm1 = class(TForm)
    DS2: TDataSource;
    DBGrid2: TDBGrid;
    DBNavigator2: TDBNavigator;
    Button1: TButton;
    Button2: TButton;
    Edit1: TEdit;
    Edit2: TEdit;
    procedure FormCreate(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure Button2Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
  Table1: TTable;
implementation

{$R *.dfm}

procedure TForm1.Button1Click(Sender: TObject);
begin
  Table1.Close;
  Table1.DeleteTable;
end;

// BeginExample: TDataSetRefresh
// Method: DBTables.TTable.SetRange
// Method: DBTables.TTable.CancelRange
// Property: DB.TDataSet.Refresh

// BeginCode
{
The following example sets a range for a dataset. The form
requires two edit boxes, a data source, a client dataset or
table, a db grid, and a button.  Make sure that the Table1
info in FormActivate agrees with the table used.  Also, the
caption for the button must be initialized to '&ApplyRange'.
}

procedure TForm1.FormActivate(Sender: TObject);
begin
  Table1.DatabaseName := 'DBDEMOS';
  Table1.TableName := 'CustInfo';
  Table1.Active := True;
  Table1.IndexName := '';
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
  if Button2.Caption = '&Apply Range' then
    begin
      Table1.SetRange([Edit1.Text],[Edit2.Text]);
      Button2.Caption := '&Drop Range';
    end
  else
    begin
      Table1.CancelRange;
      Table1.Refresh;
      Button2.Caption := '&Apply Range';
    end;
end;

procedure TForm1.FormCreate(Sender: TObject);
var
  i: Integer;
begin
  Table1:= TTable.Create(Form1);
  with Table1 do
  begin
    DatabaseName := 'DBDEMOS';
    TableType := ttParadox;
    TableName := 'CustInfo';
    Table1.Active := False;
    { Don't overwrite an existing table }
    if Table1.Exists then
      MessageDlg('CustInfo table already exists.', mtWarning, [mbOK], 0)
    else
    begin
      { The Table component must not be active }
      { First, describe the type of table and give }
      { it a name }
      { Next, describe the fields in the table }
      with FieldDefs do
      begin
        Clear;
        with AddFieldDef do
        begin
          Name := 'Field1';
          DataType := ftInteger;
          Required := True;
        end;
        with AddFieldDef do
        begin
          Name := 'Field2';
          DataType := ftString;
          Size := 30;
        end;
      end;
      { Next, describe any indexes }
      with IndexDefs do
      begin
        Clear;
        { The 1st index has no name because it is
        { a Paradox primary key }
        with AddIndexDef do
        begin
          Name := '';
          Fields := 'Field1';
          Options := [ixPrimary];
        end;
        with AddIndexDef do
        begin
          Name := 'Fld2Indx';
          Fields := 'Field2';
          Options := [ixCaseInsensitive];
        end;
      end;
      { Call the CreateTable method to create the table }
      CreateTable;
      Table1.Active:= True;
      for i := 1 to 20 do
        Table1.AppendRecord([i*111, i*222]);
    end;
  end;
  DS2.DataSet:= Table1;
  DBGrid2.DataSource.DataSet:= Table1;
  Table1.Active:= False;
end;
// EndCode
// EndExample: TDataSetRefresh
end.
