unit TDataSourceDataSet;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, DB, StdCtrls, ExtCtrls, DBCtrls, Grids, DBGrids, DBClient, SwSystem,
  DBTables;

type
  TForm1 = class(TForm)
    DS2: TDataSource;
    DBGrid2: TDBGrid;
    DBNavigator2: TDBNavigator;
    Button1: TButton;
    Button2: TButton;
    ListBox1: TListBox;
    procedure FormCreate(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
  Table1: TTable;
implementation

{$R *.dfm}

procedure TForm1.Button1Click(Sender: TObject);
begin
  Table1.Close;
  Table1.DeleteTable;
end;

// BeginExample: TDataSourceDataSet
// Property: DBGrids.TCustomDBGrid.SelectedRows
// Property: DBGrids.TBookmarkList.Count
// Property: DBGrids.TBookmarkList.Items
// Property: DBGrids.TCustomDBGrid.DataSource
// Property: DBGrids.TCustomDBGrid.FieldCount
// Property: DBGrids.TCustomDBGrid.Fields
// Method: DB.TDataSet.GotoBookmark
// Property: DB.TDataSource.DataSet

// BeginCode
{
The following example copies the selected rows in a db grid
to a list box.  Set the db grid Options dgRowSelect,
dgAlwaysShowSelection and dgMultiSelect to True.  Make a
multiple selecton using the CNTL key.  This example requires
a TDataSet associated with a TDataSource and a TDBGrid.}
procedure TForm1.Button2Click(Sender: TObject);
var
  i, j: Integer;
  s: string;
begin
  if DBGrid2.SelectedRows.Count>0 then
    with DBGrid2.DataSource.DataSet do
      for i:=0 to DBGrid2.SelectedRows.Count-1 do
      begin
        GotoBookmark(DBGrid2.SelectedRows.Items[i]);
        for j := 0 to FieldCount-1 do
        begin
          if (j>0) then s:=s+', ';
          s := s + FindField(Fields.Fields[j].FieldName).AsString;
        end;
        Listbox1.Items.Add(s);
        s:= '';
      end;
end;
// EndCode
// EndExample: TDataSourceDataSet

procedure TForm1.FormCreate(Sender: TObject);
var
  i: Integer;
begin
  Table1:= TTable.Create(Form1);
  with Table1 do
  begin
    DatabaseName := 'DBDEMOS';
    TableType := ttParadox;
    TableName := 'CustInfo';
    Table1.Active := False;
    { Don't overwrite an existing table }
    if not Table1.Exists then
    begin
      { The Table component must not be active }
      { First, describe the type of table and give }
      { it a name }
      { Next, describe the fields in the table }
      with FieldDefs do
      begin
        Clear;
        with AddFieldDef do
        begin
          Name := 'Field1';
          DataType := ftInteger;
          Required := True;
        end;
        with AddFieldDef do
        begin
          Name := 'Field2';
          DataType := ftString;
          Size := 30;
        end;
      end;
      { Next, describe any indexes }
      with IndexDefs do
      begin
        Clear;
        { The 1st index has no name because it is
        { a Paradox primary key }
        with AddIndexDef do
        begin
          Name := '';
          Fields := 'Field1';
          Options := [ixPrimary];
        end;
        with AddIndexDef do
        begin
          Name := 'Fld2Indx';
          Fields := 'Field2';
          Options := [ixCaseInsensitive];
        end;
      end;
      { Call the CreateTable method to create the table }
      CreateTable;
      Table1.Active:= True;
      for i := 1 to 20 do
        Table1.AppendRecord([i*111, i*222]);
    end;
  end;
  DS2.DataSet:= Table1;
  DBGrid2.DataSource.DataSet:= Table1;
  Table1.Active:= True;
end;
end.
