unit myTEncoding;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Label1: TLabel;
    Edit1: TEdit;
    Label2: TLabel;
    Edit2: TEdit;
    Label3: TLabel;
    ComboBox1: TComboBox;
    Memo1: TMemo;
    procedure Button1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: TEncoding
// Class: SysUtils.TEncoding
// Routine: System.SetLength
// Property: Classes.TStream.Size
// Method: Classes.THandleStream.Read
// Method: Classes.THandleStream.Write
// Method: Classes.TStream.ReadBuffer

// BeginCode
{
This example determines the encoding of a source file and then
writes the file in any encoding chosen.  Use this project to
create files of any encoding.  This example requires two text edits
and a combobox.
}
procedure TForm1.Button1Click(Sender: TObject);
var
  LBuffer: TBytes;
  LByteOrderMark: TBytes;
  LOffset: Integer;
  LEncoding, DestEncoding: TEncoding;
  LFileStream: TFileStream;
  EncodingArray: array[0..5] of TEncoding;
begin
  LEncoding:= nil;
  EncodingArray[0]:= TEncoding.UTF8;
  EncodingArray[1]:= TEncoding.UTF7;
  EncodingArray[2]:= TEncoding.Unicode;
  EncodingArray[3]:= TEncoding.Default;
  EncodingArray[4]:= TEncoding.BigEndianUnicode;
  EncodingArray[5]:= TEncoding.ASCII;
  DestEncoding := EncodingArray[ComboBox1.ItemIndex];
  LFileStream := TFileStream.Create(Edit1.Text, fmOpenRead);
  try
    // Read file into buffer
    SetLength(LBuffer, LFileStream.Size);
//    LFileStream.Read(LBuffer[0], Length(LBuffer));
    LFileStream.ReadBuffer(Pointer(LBuffer)^, Length(LBuffer));

    // Identify encoding and convert buffer to UTF8
    LOffset := TEncoding.GetBufferEncoding(LBuffer, LEncoding);
//    for I := 0 to Length(LBuffer) - 1 do
//      Memo1.Lines.Add((LBuffer[I]));
    LBuffer := LEncoding.Convert(LEncoding, DestEncoding, LBuffer,
      LOffset, Length(LBuffer) - LOffset);
  finally
    LFileStream.Free;
  end;

  LFileStream := TFileStream.Create(Edit2.Text, fmCreate);
  try
    // Write an encoding byte order mark and buffer to output file
    LByteOrderMark := DestEncoding.GetPreamble;
    LFileStream.Write(LByteOrderMark[0], Length(LByteOrderMark));
    LFileStream.Write(LBuffer[0], Length(LBuffer));
  finally
    LFileStream.Free;
  end;
end;

procedure TForm1.FormCreate(Sender: TObject);
var
  StringList: TStrings;
begin
  StringList := TStringList.Create;
  try
    with StringList do begin
      Add('TEncoding.UTF8');
      Add('TEncoding.UTF7');
      Add('TEncoding.Unicode');
      Add('TEncoding.Default');
      Add('TEncoding.BigEndianUnicode');
      Add('TEncoding.ASCII');
    end;
    with ComboBox1 do begin
      Items.Assign(StringList);
      ItemIndex := 0;
    end;
  finally
    StringList.free;
  end;
end;
// EndCode
// EndExample: TEncoding
end.
