unit TFieldFieldName;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, DB, StdCtrls, ExtCtrls, DBCtrls, Grids, DBGrids, DBClient, SwSystem,
  DBTables;

type
  TForm1 = class(TForm)
    DS2: TDataSource;
    DBGrid2: TDBGrid;
    DBNavigator2: TDBNavigator;
    Button1: TButton;
    procedure Button1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
  Table1: TTable;
implementation

{$R *.dfm}

// BeginExample: TFieldFieldName
// Method: DB.TDataSet.FieldCount
// Property: DB.TDataSet.Fields
// Property: DB.TField.FieldName

// BeginCode
{
This example displays a message box with the names of all
fields in a table.
}
procedure TForm1.Button1Click(Sender: TObject);
var
   i: Integer;
   Info: String;
begin
   Info := 'The fields of table ' + Table1.TableName +
           ' are:'#13#10#13#10;
   for i := 0 to Table1.FieldCount - 1 do
      Info := Info + Table1.Fields[i].FieldName + #13#10;
  ShowMessage(Info);
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  Table1:= TTable.Create(Form1);
  with Table1 do
  begin
    DatabaseName := 'DBDEMOS';
    TableType := ttParadox;
    TableName := 'CustInfo';
    Table1.Active := False;
    { Don't overwrite an existing table }
    if not Table1.Exists then
    begin
      { The Table component must not be active }
      { First, describe the type of table and give }
      { it a name }
      { Next, describe the fields in the table }
      with FieldDefs do
      begin
        Clear;
        with AddFieldDef do
        begin
          Name := 'Field1';
          DataType := ftInteger;
          Required := True;
        end;
        with AddFieldDef do
        begin
          Name := 'Field2';
          DataType := ftString;
          Size := 30;
        end;
      end;
      { Next, describe any indexes }
      with IndexDefs do
      begin
        Clear;
        { The 1st index has no name because it is
        { a Paradox primary key }
        with AddIndexDef do
        begin
          Name := '';
          Fields := 'Field1';
          Options := [ixPrimary];
        end;
        with AddIndexDef do
        begin
          Name := 'Fld2Indx';
          Fields := 'Field2';
          Options := [ixCaseInsensitive];
        end;
      end;
      { Call the CreateTable method to create the table }
      CreateTable;
    end;
  end;
  DS2.DataSet:= Table1;
  DBGrid2.DataSource.DataSet:= Table1;
  Table1.Active:= True;
end;
// EndCode
// EndExample: TFieldFieldName
end.
