unit TFieldGetData;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, DB, StdCtrls, ExtCtrls, DBCtrls, Grids, DBGrids, DBClient;

type
  TForm1 = class(TForm)
    CDS: TClientDataSet;
    DS: TDataSource;
    DBGrid1: TDBGrid;
    DBNavigator1: TDBNavigator;
    Button1: TButton;
    CDSHOST: TStringField;
    CDSPORTA: TIntegerField;
    Edit1: TEdit;
    procedure Button1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: TFieldGetData
// Class: DB.TBCDField
// Class: DB.TBooleanField
// Class: DB.TBytesField
// Class: DB.TDateField
// Class: DB.TDateTimeField
// Property: DB.TField.DataSize
// Class: DB.TFloatField
// Class: DB.TFMTBCDField
// Class: DB.TIntegerField
// Class: DB.TLargeintField
// Class: DB.TSmallintField
// Class: DB.TSQLTimeStampField
// Class: DB.TStringField
// Class: DB.TTimeField
// Class: DB.TVarBytesField
// Class: DB.TWordField
// Method: DB.TField.GetData
// Method: DB.TBlobField.IsBlob
// Property: DB.TField.DisplayName
// Routine: System.GetMemory

// BeginCode
{
This example requires a button, a test edit, and a populated
ClientDataSet.  Pipe the ClientDataSet through a DataSource
to a DGGrid or DBNavigator to control the current field.
Cast the data correctly according to the field type when
assigning to the test edit.
}

{$IFNDEF UNICODE}
uses SwSystem;
{$ENDIF}

procedure TForm1.Button1Click(Sender: TObject);
var MyBuffer: Pointer;
begin
{ Retrieve the "raw" data from Field1 }
with CDS.Fields[0] do
  begin
    if not IsBlob then { this does not work for BLOB fields }
    begin
      { Allocate space }
      MyBuffer:= GetMemory(DataSize);
      try
        if not GetData(MyBuffer) then
          MessageDlg(DisplayName + ' is NULL', mtInformation, [mbOK], 0)
        else
          { Do something with the data };
          Edit1.Text:= string(PAnsiChar(MyBuffer)); // for a stringfield
      finally
        { Free the space }
        FreeMem(MyBuffer, DataSize);
      end;
    end;
  end;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
{$IFDEF UNICODE}
  CDS.LoadFromFile(GetCurrentDir + '\CDS.XML');
{$ELSE}
  CDS.LoadFromFile(gsAppPath + 'CDS.XML');
{$ENDIF}
end;
// EndCode
// EndExample: TFieldGetData
end.
