unit TFindDialogOptions;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ComCtrls;

type
  TForm1 = class(TForm)
    ReplaceDialog1: TReplaceDialog;
    Button1: TButton;
    RichEdit1: TRichEdit;
    procedure ReplaceDialog1Replace(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    procedure DoReplace(FindText, ReplaceText: String);
    procedure DoReplaceAll(FindText, ReplaceText: String);
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: TFindDialogOptions
// Property: Dialogs.TFindDialog.Options
// Property: Dialogs.TReplaceDialog.ReplaceText

// BeginCode
{
The following code calls the user-defined routine DoReplace
if the Replace button was clicked, or calls the user-defined
routine DoReplaceAll if the Replace All button was clicked.
Place a TReplaceDialog, a TButton and a TRichEdit in the form.
} 
procedure TForm1.ReplaceDialog1Replace(Sender: TObject);
// var FindText, ReplaceText: String;
begin
  with Sender as TReplaceDialog do
  begin
  if frReplace in Options then
    DoReplace(ReplaceDialog1.FindText, ReplaceDialog1.ReplaceText)
  else if frReplaceAll in Options then
    DoReplaceAll(ReplaceDialog1.FindText, ReplaceDialog1.ReplaceText);
  end;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  ReplaceDialog1.Execute;
end;

procedure TForm1.DoReplace(FindText, ReplaceText: String);
begin
  ShowMessage(
    'DoReplace: FindText: ' + ReplaceDialog1.FindText +
    ' ReplaceText: ' + ReplaceDialog1.ReplaceText);
end;

procedure TForm1.DoReplaceAll(FindText, ReplaceText: String);
begin
  ShowMessage(
    'DoReplaceAll: FindText: ' + ReplaceDialog1.FindText +
    ' ReplaceText: ' + ReplaceDialog1.ReplaceText);
end;

procedure TForm1.FormCreate(Sender: TObject);
const Path = 'OverView.RTF';
begin
  RichEdit1.PlainText := False;
  RichEdit1.Lines.LoadFromFile(Path);
  RichEdit1.ScrollBars := ssVertical;
end;
// EndCode
// EndExample: TFindDialogOptions
end.
