unit TFormActionExample;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

type
  TForm1 = class(TForm)
    Label1: TLabel;
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
    procedure ChangeColor(Sender: TObject);
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: TFormAction
// Property: Controls.TControl.Action
// BeginCode
{
This example shows that OnClick is the default event of a form.
When the form is created, the OnExecute event of its Action property
is initialized to some user-defined procedure, which randomly changes
the color of the form.
}
procedure TForm1.ChangeColor(Sender: TObject);
begin
  { randomly change the color of the form }
  Color := Random($FFFF);
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  { allocate memory for the Action property }
  Action := TBasicAction.Create(Self);

  { set the OnExecute event handler }
  Action.OnExecute := ChangeColor;

  { initialize the random number generator }
  Randomize;
end;
// EndCode
// EndExample: TFormAction

end.
