unit TJPEGImageAssign;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Image1: TImage;
    Image2: TImage;
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: TJPEGImageAssign
// Method: Jpeg.TJPEGImage.Create
// Method: Jpeg.TJPEGImage.Assign
// Method: Graphics.TGraphic.SaveToFile
// Property: ExtCtrls.TImage.Stretch

// BeginCode
{
This example converts a bitmap image to a jpeg file by using
the Assign method.  This example requires a button and two
images.  One image must have it's Picture property loaded
with a bitmap at design time.
}
uses Jpeg;

procedure TForm1.Button1Click(Sender: TObject);
var
  jp: TJPEGImage;  //Requires the "jpeg" unit added to "uses" clause.
begin
  jp := TJPEGImage.Create;
  try
    with jp do
    begin
      Assign(Image1.Picture.Bitmap);
      SaveToFile('factory.jpg');
      Image2.Stretch := True;
      Image2.Picture.LoadFromFile('factory.jpg');
    end;
  finally
    jp.Free;
  end;
end;
// EndCode
// EndExample: TJPEGImageAssign
end.
