{
Add, Count, Items example
This example creates a list object and inserts two records into it. The value of the record fields are written on a paintbox:
} 
procedure TForm1.FormButton1Click(Sender: TObject);
type
  PMyList = ^AList;
  AList = record
    I: Integer;
    C: Char;
  end;
var
  MyList: TList;
  ARecord: PMyList;
  B: Byte;
  Y: Word;
begin
  MyList := TList.Create;
  try
    New(ARecord);
    ARecord^.I := 100;
    ARecord^.C := 'Z';
    MyList.Add(ARecord); {Add integer 100 and character Z to list}
    New(ARecord);
    ARecord^.I := 200;
    ARecord^.C := 'X';
    MyList.Add(ARecord); {Add integer 200 and character X to list}

    { Now paint the items onto the paintbox}
    Y := 10;             {Variable used in TextOut function}
    for B := 0 to (MyList.Count - 1) do
    begin
      ARecord := MyList.Items[B];
      Canvas.TextOut(10, Y, IntToStr(ARecord^.I)); {Display I}
      Y := Y + 30;  {Increment Y Value again}
      Canvas.TextOut(10, Y, ARecord^.C);  {Display C}
      Y := Y + 30;  {Increment Y Value}
    end;

    { Cleanup: must free the list items as well as the list }
   for B := 0 to (MyList.Count - 1) do
   begin
     ARecord := MyList.Items[B];
     Dispose(ARecord);
   end;
  finally
    MyList.Free;
  end;
end; 
