unit TListBoxSorted;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

type
  TForm1 = class(TForm)
    Add: TButton;
    Sort: TButton;
    ListBox1: TListBox;
    Edit1: TEdit;
    procedure FormCreate(Sender: TObject);
    procedure AddClick(Sender: TObject);
    procedure SortClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: TListBoxSorted
// Property: StdCtrls.TCustomListBox.Sorted

// BeginCode
{
This example uses an edit box, a list box, and two buttons
on a form. The buttons are named Add and Sort. When the user
clicks the Add button, the text in the edit box is added to
the list in the list box. Before the user clicks the sort
button, any new items are added to the end of the list.
After the user clicks the Sort button, the list in the list
box is sorted and remains sorted, even if additional strings
are added.  If the user clicks the sort button again, the
list box remains sorted, but any new strings are again added
to the end of the list.
}

procedure TForm1.FormCreate(Sender: TObject);
begin
  ListBox1.Items.Add('Not');
  ListBox1.Items.Add('In');
  ListBox1.Items.Add('Alphabetical');
  ListBox1.Items.Add('Order');
end;


procedure TForm1.AddClick(Sender: TObject);
begin
  ListBox1.Items.Add(Edit1.Text);
end;

procedure TForm1.SortClick(Sender: TObject);
begin
  ListBox1.Sorted := True;
end;
// EndCode
// EndExample: TListBoxSorted
end.
