unit SubItems;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ComCtrls;

type
  TForm1 = class(TForm)
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: TListItemSubItems
// Property: ComCtrls.TCustomListView.Columns
// Property: ComCtrls.TListColumn.Caption
// Property: ComCtrls.TCustomListView.Items
// Property: ComCtrls.TListItem.SubItems
// Method: ComCtrls.TListItems.Add
// Property: ComCtrls.TCustomListView.ViewStyle
// Method: ComCtrls.TCustomListView.Create

// BeginCode
{
This example requires only a blank form.  All other objects:
TListView, TListColumns, TListItems, are created dynamically.
You must add comctrls to the uses clause of the unit file.
} 
procedure TForm1.FormCreate(Sender: TObject);
const
  Names: array[0..5, 0..1] of string = (
    ('Rubble', 'Barney'),
    ('Michael', 'Johnson'),
    ('Bunny', 'Bugs'),
    ('Silver', 'HiHo'),
    ('Simpson', 'Bart'),
    ('Squirrel', 'Rocky')
    );

var
  I: Integer;
  NewColumn: TListColumn;
  ListItem: TListItem;
  ListView: TListView;
begin
  ListView := TListView.Create(Self);
  with ListView do
  begin
    Parent := Self;
    Align := alClient;
    ViewStyle := vsReport;

    NewColumn := Columns.Add;
    NewColumn.Caption := 'Last';
    NewColumn := Columns.Add;
    NewColumn.Caption := 'First';

    for I := Low(Names) to High(Names) do
    begin
      ListItem := Items.Add;
      ListItem.Caption := Names[I][0];
      ListItem.SubItems.Add(Names[I][1]);
    end;
  end;
end;
// EndCode
// EndExample: TListItemSubItems
end.
