unit TListItemsInsert;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ComCtrls;

type
  TForm1 = class(TForm)
    Button1: TButton;
    ListView1: TListView;
    Edit1: TEdit;
    procedure Button1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: TListItemsInsert
// Method: ComCtrls.TListItems.Insert
// Property: ComCtrls.TCustomListView.Selected
// Property: ComCtrls.TListItem.Index

// BeginCode
{
The following example inserts a list item before the selected
item in the list view.  Place a TButton, a TEdit and a
TListView in the form.
} 
procedure TForm1.Button1Click(Sender: TObject);
var InsertItem : TListItem;
begin
  with ListView1 do
  begin
    if (Selected = nil) then exit;
    InsertItem := Items.Insert(Selected.Index);
  end;
  InsertItem.Caption := Edit1.Text;
end;

procedure TForm1.FormCreate(Sender: TObject);
var ListItem : TListItem;
begin
  ListView1.ViewStyle := vsList;
  ListItem := ListView1.Items.Add;
  ListItem.Caption := 'Apples';
  ListItem := ListView1.Items.Add;
  ListItem.Caption := 'Oranges';
  ListItem := ListView1.Items.Add;
  ListItem.Caption := 'Pears';
end;
// EndCode
// EndExample: TListItemsInsert
end.
