unit TListLast;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Button2: TButton;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: TListLast
// Method: Classes.TList.Last

// BeginCode
{
This example inserts two records into a list object and
displays the contents of the last record in the list on the form:
}
procedure TForm1.Button1Click(Sender: TObject);
type
  PMyList = ^AList;
  AList = record
    I: Integer;
    C: Char;
  end;
var
  MyList: TList;
  ARecord: PMyList;
  I: integer;
begin
  MyList := TList.Create;
  New(ARecord);
  ARecord^.I := 100;
  ARecord^.C := 'Z';
  MyList.Add(ARecord); {Add integer 100 and character Z to list}
  New(ARecord);
  ARecord^.I := 200;
  ARecord^.C := 'X';
  MyList.Add(ARecord); {Add integer 200 and character X to list}
  ARecord := MyList.Last;
  Canvas.TextOut(10, 10, IntToStr(ARecord^.I)); {Display I}
  Canvas.TextOut(10, 40, ARecord^.C);  {Display C}
  { Cleanup: must free the list items as well as the list }
  for I := 0 to (MyList.Count - 1) do
  begin
    ARecord := MyList.Items[I];
    Dispose(ARecord);
  end;
  MyList.Free;
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
  Refresh;
end;
// EndCode
// EndExample: TListLast
end.
