unit TListPack;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

type
  TForm1 = class(TForm)
    Edit1: TEdit;
    Edit2: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    Button1: TButton;
    procedure FormCreate(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormPaint(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
  MyList: TList;

implementation

{$R *.dfm}

procedure DisplayTList(TheList: TList);
var
  B: Byte;
  Y: Word;
  str: string;
begin
    { Now paint the items onto the paintbox}
    Y := 10;             {Variable used in TextOut function}
    for B := 0 to (TheList.Count - 1) do
    begin
      str:= PChar(TheList.Items[B]);
      Form1.Canvas.TextOut(10, Y, str);
      Y := Y + 30;  {Increment Y Value again}
    end;
end;

// BeginExample: TListPack
// Method: Classes.TList.Pack

// BeginCode
{
This example requires two edit box controls and a button on
the form. The code creates a list object and adds some
strings to it. The second string in the list is a nil string.
The code counts the number of strings in the list and
displays the number in the Edit1 control. The code then
packs the list, removing the nil string, and counts the
strings in the list again. The second count displays in the
Edit2 control:
}
procedure TForm1.FormCreate(Sender: TObject);
var
  I: Integer;
begin
  MyList := TList.Create;              {Create a list }
  MyList.Add(PChar('A string')); {Add a string}
  MyList.Add(PChar('')); { Add an empty string }
  MyList.Add(PChar('A third string')); {Add a string}
  MyList.Add(nil);              {Add nil }
  MyList.Add(PChar('A fifth string')); {Add a string}
  MyList.Add(PChar('')); { Add another empty string }
  MyList.Add(PChar('A seventh string')); {Add a string}
  Edit1.Text := IntToStr(MyList.Count); {Put count into Edit1}
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  MyList.Pack;                         {Pack the list.}
  Edit2.Text := IntToStr(MyList.Count); {Put count into Edit2}
  Repaint;
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
  MyList.Free;                         {Free memory for list}
end;

procedure TForm1.FormPaint(Sender: TObject);
begin
  DisplayTList(MyList);
end;
// EndCode
// EndExample: TListPack
end.
