{
OnColumnClick, AlphaSort, OnCompare, CompareText example
This example shows how to use the OnColumnClick and OnCompare events of a list view to let users sort the columns in a report-style list view by clicking on the column headers. This requires a global variable to keep track of the column that was clicked:
The OnColumnClick event handler sets the global variable to indicate the column to sort and calls AlphaSort:
} 
var ColumnToSort: Integer;

procedure TForm1.ListView1ColumnClick(Sender: TObject; Column: TListColumn);
begin
  ColumnToSort := Column.Index;
  (Sender as TCustomListView).AlphaSort;
end;

{
The OnCompare event handler causes the list view to sort on the selected column:
}
procedure TForm1.ListView1Compare(Sender: TObject; Item1, Item2: TListItem; Data: Integer; var Compare: Integer);
var
  ix: Integer;
begin
  if ColumnToSort = 0 then
    Compare := CompareText(Item1.Caption,Item2.Caption)
  else begin
   ix := ColumnToSort - 1;
   Compare := CompareText(Item1.SubItems[ix],Item2.SubItems[ix]);
  end;
end;
{
Note:	This OnCompare event handler uses the global CompareText function. An application may want to use AnsiCompareText, CompareStr, or AnsiCompareStr instead, depending on whether the comparison should be case-sensitive and whether the locale should be considered.
} 
