unit TMediaPlayerEject;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, MPlayer;

type
  TForm1 = class(TForm)
    MediaPlayer1: TMediaPlayer;
    Timer1: TTimer;
    procedure FormClick(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
  TimeOver: Integer = 0;
implementation

{$R *.dfm}

// BeginExample: TMediaPlayerEject
// Method: MPlayer.TMediaPlayer.Eject
// Method: MPlayer.TMediaPlayer.Close
// Property: ExtCtrls.TTimer.Enabled

// Warning: CD audio device not installed.

// BeginCode
{
This code ejects the CD from the CD-ROM player and shuts 
down the media player after 10 seconds. For the code to run
correctly, you must have your CD audio device installed
correctly, and the device must have software-ejecting 
capabilities.
} 
var
  TimerOver: Word;

procedure TForm1.FormClick(Sender: TObject);
begin
  MediaPlayer1.DeviceType := dtCDAudio;
  MediaPlayer1.Open;
  MediaPlayer1.Play;
end;

procedure TForm1.Timer1Timer(Sender: TObject);
begin
  if TimeOver = 10 then
  begin
    MediaPlayer1.Eject;
    MediaPlayer1.Close;
    { disable the timer, as we are done }
    Timer1.Enabled := False;
  end
  else
    if (MediaPlayer1.Mode = mpOpen) then
     Inc(TimeOver);
end;
// EndCode
// EndExample: TMediaPlayerEject
end.
