unit TMetafileCreate;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Button2: TButton;
    PaintBox1: TPaintBox;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
implementation

{$R *.dfm}

// BeginExample: TMetafileCreate
// Property: Graphics.TMetafile.Create
// Method: Graphics.TMetafileCanvas.Create

// BeginCode
{
This example shows how to create or augment a metafile using
a metafile canvas object.  This metafile can then be used to
draw on the canvas of another object such as a paintbox or a
printer.
}

var
  MyMetafile: TMetafile;

procedure TForm1.Button1Click(Sender: TObject);
begin
  MyMetafile := TMetafile.Create;
  with TMetafileCanvas.Create(MyMetafile, 0) do
  try
    Brush.Color := clRed;
    Ellipse(0, 0, 100, 200);
    //  ...
  finally
//    Free;
  end;
  Form1.Canvas.Draw(0, 0, MyMetafile); {1 red circle }
  PaintBox1.Canvas.Draw(0, -50, MyMetafile); {1 red circle }
end;

{
To add to an existing metafile image, create a metafile
canvas and play the source metafile into the metafile canvas:
}
procedure TForm1.Button2Click(Sender: TObject);
begin
  if (MyMetafile = nil) then exit;  { click Button1 first! }
  
  with TMetafileCanvas.Create(MyMetafile, 0) do
  try
    Draw(-50, 0, MyMetafile);
    Brush.Color := clBlue;
    Ellipse(100, 100, 300, 200);
// ...
  finally
//    Free;
  end;
  Form1.Canvas.Draw(0, 0, MyMetafile); {1 red circle and 1 blue circle }
  PaintBox1.Canvas.Draw(0, 0, MyMetafile); {1 red circle and 1 blue circle }
end;
// EndCode
// EndExample: TMetafileCreate
end.
