{
Create example
This example shows how to create or augment a metafile using a metafile canvas object.  This metafile can then be used to draw on the canvas of another object such as a paintbox or a printer.
}
MyMetafile := TMetafile.Create;
with TMetafileCanvas.Create(MyMetafile, 0) do
try
  Brush.Color := clRed;
  Ellipse(0,0,100,100);
  ...
finally
  Free;
end;
Form1.Canvas.Draw(0,0,MyMetafile); {1 red circle }

{
To add to an existing metafile image, create a metafile canvas and play the source metafile into the metafile canvas:
} 
with TMetafileCanvas.Create(MyMetafile, 0) do
try
  Draw(0,0,MyMetafile);
  Brush.Color := clBlue;
  Ellipse(100,100,200,200);
...
finally
  Free;
end;
Form1.Canvas.Draw(0,0,MyMetafile); {1 red circle and 1 blue circle } 
