unit TMouseExample;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, AppEvnts, ExtCtrls;

type
  TForm1 = class(TForm)
    CheckBox1: TCheckBox;
    CheckBox2: TCheckBox;
    Label1: TLabel;
    Edit2: TEdit;
    Label2: TLabel;
    Label3: TLabel;
    Edit3: TEdit;
    Timer1: TTimer;
    Label4: TLabel;
    Edit1: TEdit;
    procedure FormCreate(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: TMouse
// Class: Controls.TMouse
// Property: Controls.TMouse.MousePresent
// Property: Controls.TMouse.WheelPresent
// Property: Controls.TMouse.WheelScrollLines
// Property: Controls.TMouse.CursorPos
// BeginCode
{
This example uses two check boxes, three edit boxes and
a timer component on a form.  When the application starts,
the check boxes get checked by the application depending on
whether a mouse is detected and whether
a wheel button is available. The first edit box displays
the number of lines that are scrolled each time the wheel button
is rotated. The other two edit boxes display the position
of the mouse cursor at each millisecond, using the timer component.
}
procedure TForm1.FormCreate(Sender: TObject);
begin
  CheckBox1.Checked := Mouse.MousePresent;
  CheckBox2.Checked := Mouse.WheelPresent;
  Edit1.Text := IntToStr(Mouse.WheelScrollLines);
  Edit2.Text := IntToStr(Mouse.CursorPos.X);
  Edit3.Text := IntToStr(Mouse.CursorPos.Y);
end;

procedure TForm1.Timer1Timer(Sender: TObject);
begin
  Edit1.Text := IntToStr(Mouse.WheelScrollLines);
  Edit2.Text := IntToStr(Mouse.CursorPos.X);
  Edit3.Text := IntToStr(Mouse.CursorPos.Y);
end;
// EndCode
// EndExample: TMouse

end.
