unit TOpenDialogFileName;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

type
  TForm1 = class(TForm)
    Edit1: TEdit;
    OpenDialog1: TOpenDialog;
    procedure Edit1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: TOpenDialogFileName
// Property: Dialogs.TOpenDialog.FileName
// Method: Dialogs.TOpenDialog.Execute
// Routine: System.AssignFile
// Routine: System.Readln
// Routine: System.CloseFile

// BeginCode
{
Use a TOpenDialog to select a file.  Place the first line of
the file into a TEdit.  Click on the text edit to open the
open dialog box. 
}
procedure TForm1.Edit1Click(Sender: TObject);
var
  F: TextFile;
  S: string;
begin
  if OpenDialog1.Execute then            { Display Open dialog box }
  begin
    AssignFile(F, OpenDialog1.FileName); { File selected in dialog }
    Reset(F);
    Readln(F, S);                        { Read first line of file }
    Edit1.Text := S;                     { Put string in a TEdit control }
    CloseFile(F);
  end;
end;
// EndCode
// EndExample: TOpenDialogFileName
end.
