unit TOpenDialogTitle;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Grids;

type
  TForm1 = class(TForm)
    Button1: TButton;
    OpenDialog1: TOpenDialog;
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: TOpenDialogTitle
// Property: Dialogs.TOpenDialog.Title
// Property: Dialogs.TOpenDialog.FileName
// Routine: System.CloseFile
// Routine: System.Erase
// Routine: System.Reset
// Routine: System.AssignFile
// Class: SysUtils.EInOutError

// BeginCode
{
Click the button to open a TOpenDialog, then select a file 
to delete.
}

procedure TForm1.Button1Click(Sender: TObject);
var
  F: Textfile;
begin
  OpenDialog1.Title := 'Delete File';
  if OpenDialog1.Execute then
  begin
    AssignFile(F, OpenDialog1.FileName);
    try
      Reset(F);
      if MessageDlg('Erase ' + OpenDialog1.FileName + '?',
        mtConfirmation, [mbYes, mbNo], 0) = mrYes then
      begin
        CloseFile(F);
        Erase(F);
      end;
    except
      on EInOutError do
        MessageDlg('File I/O error.', mtError, [mbOk], 0);
    end;
  end;
end;
// EndCode
// EndExample: TOpenDialogTitle
end.
