unit TParamsAssign;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, DB, StdCtrls, ExtCtrls, DBCtrls, Grids, DBGrids, DBClient;

type
  TForm1 = class(TForm)
    CDS: TClientDataSet;
    DS: TDataSource;
    DBGrid1: TDBGrid;
    DBNavigator1: TDBNavigator;
    Button1: TButton;
    Button2: TButton;
    CDSHOST: TStringField;
    CDSPORTA: TIntegerField;
    Button3: TButton;
    CDS2: TClientDataSet;
    DS2: TDataSource;
    DBGrid2: TDBGrid;
    Button4: TButton;
    Button5: TButton;
    DBNavigator2: TDBNavigator;
    SaveParams: TButton;
    AlterParams: TButton;
    RestoreParams: TButton;
    procedure Button3Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure SaveParamsClick(Sender: TObject);
    procedure AlterParamsClick(Sender: TObject);
    procedure RestoreParamsClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

{$IFNDEF UNICODE}
uses SwSystem;
{$ENDIF}

procedure TForm1.Button1Click(Sender: TObject);
begin
{$IFDEF UNICODE}
  CDS.LoadFromFile(GetCurrentDir + '\CDS.XML');
{$ELSE}
  CDS.LoadFromFile(gsAppPath + 'CDS.XML');
{$ENDIF}
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
{$IFDEF UNICODE}
  CDS.SaveToFile(GetCurrentDir + '\CDS.XML', dfXML);
{$ELSE}
  CDS.SaveToFile(gsAppPath + 'CDS.XML', dfXML);
{$ENDIF}
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
  CDS.CreateDataSet;
end;

procedure TForm1.Button4Click(Sender: TObject);
begin
  CDS2.Data := CDS.Data;
end;

procedure TForm1.Button5Click(Sender: TObject);
begin
  CDS.Close;
end;

// BeginExample: TParamsAssign
// Method: Classes.TCollection.Assign
// Method: DB.TParams.AssignValues
// Method: DB.TParams.CreateParam

// BeginCode
{
  This example saves params from a ClientDataSet, alters them
  and restores them.
}
var SavedParams: TParams;

procedure TForm1.SaveParamsClick(Sender: TObject);
begin
  { Save the parameters for the TDataSet }
  SavedParams.Assign(CDS.Params);
end;

procedure TForm1.AlterParamsClick(Sender: TObject);
var
  I : Integer;
begin
  CDS.Params.CreateParam(ftInteger, 'StateParam', ptInput);
  CDS.Params.CreateParam(ftInteger, 'MyParam', ptInput);
  for I := 0 to CDS.Params.Count - 1 do
    if (CDS.Params.Items[I].IsNull) and
       (CDS.Params.Items[I].DataType = ftInteger) then
      { Items is the default property, so you can omit its name }
      CDS.Params[I].AsInteger := -1;
end;

procedure TForm1.RestoreParamsClick(Sender: TObject);
begin
  { Restore the parameters to TDataSet }
  CDS.Params.AssignValues(SavedParams);
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  { Initialize SavedParams }
  SavedParams := TParams.Create;
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
  SavedParams.Free;
end;
// EndCode
// EndExample: TParamsAssign
end.
