unit TParamsItems;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, DB, StdCtrls, DBClient, Grids, DBGrids, ExtCtrls, DBCtrls;

type
  TForm1 = class(TForm)
    Button1: TButton;
    CDS: TClientDataSet;
    DS: TDataSource;
    DBGrid1: TDBGrid;
    DBNavigator1: TDBNavigator;
    procedure Button1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: TParamsItems
// Property: DB.TParams.Items
// Property: Classes.TCollection.Count
// Property: DB.TParam.DataType
// Property: DB.TParam.IsNull
// Property: DB.TParam.AsInteger

// BeginCode
{
This example requires a TClientDataSet and a button on a form.
}
{$IFNDEF UNICODE}
uses SwSystem;
{$ENDIF}

procedure TForm1.Button1Click(Sender: TObject);
var
  I : Integer;
begin
{ Assign -1 to any integer parameter which does not have a value. }
for I := 0 to CDS.Params.Count - 1 do
  if (CDS.Params.Items[I].IsNull) and
     (CDS.Params.Items[I].DataType = ftInteger) then
    { Items is the default property, so you can omit its name }
    CDS.Params[I].AsInteger := -1;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
{$IFDEF UNICODE}
  CDS.LoadFromFile(GetCurrentDir + '\CDS.XML');
{$ELSE}
  CDS.LoadFromFile(gsAppPath + 'CDS.XML');
{$ENDIF}
  CDS.Params.CreateParam(ftInteger, 'StateParam', ptInput);
  CDS.Params.CreateParam(ftInteger, 'MyParam', ptInput);
end;
// EndCode
// EndExample: TParamsItems
end.
