unit TPrintDialogFromPage;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ComCtrls, StdCtrls, Printers, ExtDlgs;

type
  TForm1 = class(TForm)
    Button1: TButton;
    PageControl1: TPageControl;
    PrintDialog1: TPrintDialog;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    TabSheet3: TTabSheet;
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: TPrintDialogFromPage
    // Property: Dialogs.TPrintDialog.FromPage
    // Property: Dialogs.TPrintDialog.MaxPage
    // Property: Dialogs.TPrintDialog.MinPage
    // Property: Dialogs.TPrintDialog.Options
    // Property: Dialogs.TPrintDialog.PrintRange
    // Property: Dialogs.TPrintDialog.ToPage
    // Method: Dialogs.TPrintDialog.Execute
    // Method: Controls.TWinControl.PaintTo
    // Method: Printers.TPrinter.BeginDoc
    // Method: Printers.TPrinter.EndDoc
    // Method: Printers.TPrinter.NewPage
    // Property: Printers.TPrinter.Handle
    // Routine: Printers.Printer

// BeginCode
{
This example uses a button, a Page Control, and a Print 
dialog box on a form. When the user clicks the button, the
print dialog is displayed.  The user can select any subset 
of the pages in the page control for printing.  The selected
pages are then printed.  To run this example successfully, 
you must add the Printers unit to the uses clause of your 
unit.  Right click on the PageControl to add at least one 
page to the PageControl.
}
procedure TForm1.Button1Click(Sender:TObject);
var
  I, Start, Stop: Integer;
begin
PrintDialog1.Options := [poPageNums, poSelection];
PrintDialog1.FromPage := 1;
PrintDialog1.MinPage := 1;
PrintDialog1.ToPage := PageControl1.PageCount;
PrintDialog1.MaxPage := PageControl1.PageCount;

if PrintDialog1.Execute() then
  begin
    { determine the range the user wants to print }
    with PrintDialog1 do
    begin
      if PrintRange = prAllPages then
        begin
        Start := MinPage - 1;
        Stop := MaxPage - 1;
      end
      else if PrintRange = prSelection then
      begin
        Start := PageControl1.ActivePage.PageIndex;
        Stop := Start;
        end
      else  { PrintRange = prPageNums }
      begin
        Start := FromPage - 1;
        Stop := ToPage - 1;
      end;
    end;
    { now, print the pages }
    with Printer do
    begin
      BeginDoc;
      for I := Start to Stop do
      begin
        PageControl1.Pages[I].PaintTo(Handle, 10, 10);
        if I <> Stop then
          NewPage;
      end;
      EndDoc;
    end;
  end;
end;
// EndCode
// EndExample: TPrintDialogFromPage
end.
