unit TProgressBarEx;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ComCtrls, StdCtrls, ExtCtrls;

type
  TTForm1 = class(TForm)
    ProgressBar1: TProgressBar;
    StartBTN: TButton;
    PauseBTN: TButton;
    ErrorBTN: TButton;
    ReverseBTN: TButton;
    Timer1: TTimer;
    procedure StartBTNClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure PauseBTNClick(Sender: TObject);
    procedure ErrorBTNClick(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure ReverseBTNClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  TForm1: TTForm1;

implementation

{$R *.dfm}

// BeginExample: TProgressBar
// Property: ParrentDoubleBuffered
// Property: Style
// Property: MarqueeInterval
// Property: BarColor
// Property: BackgroundColor
// Property: SmoothReverse
// Property: State
// Enumeration: TProgressBarState
// Enumeration: TProgressBarStyle

//BeginCode
{
The following code shows an example of how to use the properties of a
TProgressBar type object.
}

procedure TTForm1.FormCreate(Sender: TObject);
begin
  ProgressBar1.BarColor := clRed;
  ProgressBar1.BackgroundColor := clGreen;
  ProgressBar1.ParentDoubleBuffered := True;
  ProgressBar1.Style := pbstMarquee;
  ProgressBar1.MarqueeInterval := 1000;
  Timer1.Enabled := False;
end;

procedure TTForm1.StartBTNClick(Sender: TObject);
begin
  ProgressBar1.Position := 0;
  ProgressBar1.Style := pbstNormal;
  Timer1.Enabled := True;
  Timer1Timer(Timer1);
end;

procedure TTForm1.PauseBTNClick(Sender: TObject);
begin
  if ProgressBar1.State = pbsPaused then
    ProgressBar1.State := pbsNormal
  else
    ProgressBar1.State := pbsPaused;
end;

procedure TTForm1.ErrorBTNClick(Sender: TObject);
begin
  ProgressBar1.State := pbsError;
end;

procedure TTForm1.ReverseBTNClick(Sender: TObject);
begin
  ProgressBar1.SmoothReverse := True;
end;

procedure TTForm1.Timer1Timer(Sender: TObject);
begin
  ProgressBar1.Position := ProgressBar1.Position + 10;
end;
//EndCode
//EndExample: TProgressBar

end.
