unit TProgressBarStepIt;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ComCtrls, StdCtrls, Math;

type
  TForm1 = class(TForm)
    Button1: TButton;
    ProgressBar1: TProgressBar;
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: TProgressBarStepIt
// Property: ComCtrls.TProgressBar.Step
// Method: ComCtrls.TProgressBar.StepIt

// BeginCode
{
This example reads bytes from a file in tenths of the size
of the file. The ProgressBar displays the status of each
1/10th step as it's read into the buffer.  This example
requires a TButton and a TProgressBar control on the form.
} 
procedure TForm1.Button1Click(Sender: TObject);
const
  FName = 'about.txt';  // use a file larger than 2048 bytes to make it interesting.
var
  F: File;
  MyData: array[1..2048] of byte;
  BytesRead: LongInt;
begin
  AssignFile(F, FName);
  try
    Reset(F, 1);
    ProgressBar1.Max := FileSize(F);
    if (ProgressBar1.Max > 10) then
    begin
      // amount to move when StepIt method called
      ProgressBar1.Step := ProgressBar1.Max div 10;
      ProgressBar1.Step := Min(ProgressBar1.Step, 2048);
    end
    else
      ProgressBar1.Step := ProgressBar1.Max;
    while (ProgressBar1.Position < ProgressBar1.Max) do
    begin
      // read one Step size chunk of data to buffer
      BlockRead(F, MyData, ProgressBar1.Step, BytesRead);
      // move the ProgressBar Position using StepIt
      ProgressBar1.StepIt; // move by Step amount
      // Do this or the read will wrap and start over!
      ProgressBar1.Step :=
          Min(ProgressBar1.Step, ProgressBar1.Max - ProgressBar1.Position);

    end;
  finally;
    CloseFile(F);
  end;
end;
// EndCode
// EndExample: TProgressBarStepIt
end.
