{
Step, StepIt example
This example reads bytes from a file in tenths of the size of the file. The ProgressBar displays the status of each 1/10th step as it's read into the buffer.  
The example requires a TButton and a TProgressBar control on the form.
} 
procedure TForm1.Button1Click(Sender: TObject);
const
  // On Windows replace, myfile with a pathname such as c:\autoexec.bat
  FName = 'MyFile';
var
  F: File;
  MyData: array[1..2048] of byte;
  BytesRead: LongInt;
begin
  AssignFile(F, FName);
  try
    Reset(F);
    ProgressBar1.Max := FileSize(F);
    if (ProgressBar1.Max > 10) then
      // amount to move when StepIt method called
      ProgressBar1.Step := ProgressBar1.Max div 10
    else
      ProgressBar1.Step := ProgressBar1.Max;
    while (ProgressBar1.Position < ProgressBar1.Max) do
    begin
      // read one Step size chunk of data to buffer
      BlockRead(F, MyData, ProgressBar1.Step, BytesRead);
      // move the ProgressBar Position using StepIt
      ProgressBar1.StepIt; // move by Step amount
    end;
  finally;
    CloseFile(F);
  end;
end;
 
