unit TScreenCursor;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

type
  TForm1 = class(TForm)
    Button1: TButton;
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: TScreenCursor
// Property: Forms.TScreen.Cursor

// BeginCode
{
Assignments to the Screen object's cursor property are
typically guarded by a try...finally statement to ensure
that normal cursor behavior is restored. Note that the
original cursor is saved and restored.  This allows cursor
changes to be nested without accidentally restoring the
cursor to a hard-coded value prematurely.
}
procedure TForm1.Button1Click(Sender: TObject);
var 
  Save_Cursor : TCursor;
  I, J: Integer;
  X, Y: Word;
const
  magicnumber = 3000000;
begin
  Save_Cursor := Screen.Cursor;
  Screen.Cursor := crHourGlass;    { Show hourglass cursor }
  try
    { Do some lengthy operation }
  I := 0;
  J := 0;
  while I < magicnumber do
  begin
    Randomize;
    while J < magicnumber do
    begin
      Y := Random(J);
      Inc(J);
    end;
    X := Random(I);
    Inc(I);
  end;
  finally
    Screen.Cursor := Save_Cursor;  { Always restore to normal }
  end;
end;
// EndCode
// EndExample: TScreenCursor
end.
