{
Cursor example
Assignments to the Screen object's cursor property are typically guarded by a try...finally statement to ensure that normal cursor behavior is restored. Note that the original cursor is saved and restored.  This allows cursor changes to be nested without accidentally restoring the cursor to a hard-coded value prematurely.
} 
var 
  Save_Cursor:TCursor;
begin
  Save_Cursor := Screen.Cursor;
  Screen.Cursor := crHourGlass;    { Show hourglass cursor }
  try
    { Do some lengthy operation }
  finally
    Screen.Cursor := Save_Cursor;  { Always restore to normal }
  end;
end;
 
