unit TStringsMove;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

type
  TForm1 = class(TForm)
    ListBox1: TListBox;
    Button1: TButton;
    procedure FormCreate(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: TStringsMove
// Property: Controls.TCustomMultiSelectListControl.MultiSelect
// Property: Controls.TCustomListControl.ItemIndex
// Method: Classes.TStrings.Move

// BeginCode
{
This example uses a list box and a button on a form. The
list box contains items when the form appears. When the user
clicks the button, the selected item in the list box is
moved to the top of the list box:
}
procedure TForm1.Button1Click(Sender: TObject);
begin
  if (ListBox1.ItemIndex in [0..9]) then
    ListBox1.Items.Move(ListBox1.ItemIndex, 0);
end;

procedure TForm1.FormCreate(Sender: TObject);
var
  I: Integer;
begin
  ListBox1.MultiSelect := False;
  Button1.Caption := 'Move to Top';
  for I := 1 to 10 do
    ListBox1.Items.Add('Item ' + IntToStr(I));
end;
// EndCode
// EndExample: TStringsMove
end.
