unit TTcpClientSendStream;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Sockets, StdCtrls;

type
  TForm3 = class(TForm)
    Button1: TButton;
    TcpClient1: TTcpClient;
    Memo1: TMemo;
    Edit1: TEdit;
    procedure Button1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure TcpClient1Send(Sender: TObject; Buf: PWideChar;
      var DataLen: Integer);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form3: TForm3;

implementation

{$R *.dfm}

// BeginExample: TTcpClientSendStream
// Class: Sockets.TTcpClient
// Method: Sockets.TBaseSocket.SendStream
// Method: Sockets.TBaseSocket.OnSend
// Property: Sockets.TIpSocket.RemoteHost
// Property: Sockets.TIpSocket.RemotePort
// Property: Sockets.TBaseSocket.Active
// BeginCode
{
	This example demontrates the use of SendStream method. It is to be
	used with the example from TTcpServer section.
}
const DEFAULT_PORT = 2501;

procedure TForm3.Button1Click(Sender: TObject);
var
  myStream : TMemoryStream;
  I : Cardinal;
  userValue : Integer;
begin
  //creating a stream
  myStream := TMemoryStream.Create();
  for I := 0 to 8 do
  begin
    myStream.WriteBuffer(I,1);
  end;
  userValue := StrToIntDef(Edit1.Text, 0);
  myStream.WriteBuffer(userValue,1);

  //resetting the stream position
  myStream.Seek(0,0);

  //sending the stream
  TcpClient1.Active := true;
  TcpClient1.SendStream(myStream);
  TcpClient1.Active := false;

  //free the stream
  myStream.Free;

end;

procedure TForm3.FormCreate(Sender: TObject);
begin
  Edit1.Text := '0';
  Memo1.Lines.Clear;

  TcpClient1.RemotePort := IntToStr(DEFAULT_PORT);
  TcpClient1.RemoteHost := 'localhost';
  TcpClient1.Active := true;
end;

procedure TForm3.TcpClient1Send(Sender: TObject; Buf: PWideChar;
  var DataLen: Integer);
begin
  Memo1.Lines.Add(DateTimeToStr(now) + ' Sent data with ' + Edit1.Text);
end;

// EndCode
// EndExample: TTcpClientSendStream

end.
