unit TThreadPriority;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Memo1: TMemo;
    Memo2: TMemo;
    Button2: TButton;
    Memo3: TMemo;
    Button3: TButton;
    Button4: TButton;
    Button5: TButton;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;
  TMyThread = class(TThread)
  protected
    procedure Execute; override;
  end;
  TYouThread = class(TThread)
  protected
    procedure Execute; override;
  end;

var
  Form1: TForm1;
  mythreadRunning, youthreadRunning: Boolean;
  MyProcess: TMyThread; { TMyThread is a custom descendant of TThread }
  YouProcess: TYouThread; { TYouThread is a custom descendant of TThread }
implementation

{$R *.dfm}

{
constructor TMyThread.Create(CreateSuspended: Boolean);
begin
  FreeOnTerminate := True;
  Priority := tpLower;  // set the priority to lower than normal
  inherited Create(CreateSuspended);
end;
}

// BeginExample: TThreadPriority
// Method: Classes.TThread.Create
// Property: Classes.TThread.Priority
// Property: Classes.TThread.FreeOnTerminate
// Method: Classes.TThread.Resume
// Method: Classes.TThread.Execute
// Enumeration: Classes.TThreadPriority

// BeginCode
{
This example shows how to create a thread and start it
running at a lower priority than the main execution thread.
Set the threads FreeOnTerminate property is True, so that
there is no need to free the thread when it finishes.  The
Execute procedure must be overridden in the extension class
of TThread or an "Abstract Error" will result. To create the
extension choose the File | New | Other | Thread Object menu.
}
procedure TForm1.Button1Click(Sender: TObject);
begin
  if (mythreadRunning = FALSE) then
  begin
    mythreadRunning:= TRUE;
    MyProcess := TMyThread.Create(True); { create suspended - secondprocess does not run yet }
    MyProcess.FreeOnTerminate := True; { don't need to cleanup after terminate }
    MyProcess.Priority := tpLower;  // set the priority to lower than normal
    MyProcess.Resume; { now run the thread }
  end
  else
    MessageDlg('This thread is still running.  You are going to hurt yourself!',
      mtInformation, [mbOk], 0);
end;

procedure TForm1.Button4Click(Sender: TObject);
begin
  if mythreadRunning then MyProcess.Terminate();
end;

procedure TMyThread.Execute;
var I: Integer;
begin
  Form1.Memo1.Lines.Add('Process has been running for this many seconds:');
  for I := 0 to 10 do
  begin
    if Terminated then break;
    Form1.Memo1.Lines.Add('Low priority process ' + InttoStr(I));
    Sleep(1000);
  end;
  mythreadRunning:= FALSE;
end;

procedure TYouThread.Execute;
var I: Integer;
begin
  Form1.Memo3.Lines.Add('Second low priority process has been running for this many seconds:');
  for I := 0 to 10 do
  begin
    if Terminated then break;
    Form1.Memo3.Lines.Add('Second low priority process ' + InttoStr(I));
    Sleep(1000);
  end;
    youthreadRunning:= FALSE;
end;

procedure TForm1.Button2Click(Sender: TObject);
var   I: Integer;
begin
  Form1.Memo2.Lines.Add('Do some work in the main process for 10 seconds:');
  for I := 0 to 10 do
  begin
    Form1.Memo2.Lines.Add('Main process ' + InttoStr(I));
    Sleep(1000);
  end;
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
  if (youthreadRunning = FALSE) then
  begin
    youthreadRunning:= TRUE;
    YouProcess := TYouThread.Create(True); { create suspended  secondprocess does not run yet }
    YouProcess.FreeOnTerminate := True; { don't need to cleanup after terminate }
    YouProcess.Priority := tpLower;  // set the priority to lower than normal
    YouProcess.Resume; { now run the thread }
  end
  else
    MessageDlg('This thread is still running.  You are going to hurt yourself!',
      mtInformation, [mbOk], 0);
end;

procedure TForm1.Button5Click(Sender: TObject);
begin
  if youthreadRunning then YouProcess.Terminate();
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  mythreadRunning:= FALSE;
  youthreadRunning:= FALSE;
end;
// EndCode
// EndExample: TThreadPriority
end.
