{
AllocateHWnd, DeallocateHWnd example
The following code is from the implementation of TTimer. It shows how the timer 
components constructor creates a hidden window to respond to Timer messages and 
how the destructor frees that window.
}
{TTimer implements a WndProc method that becomes the window procedure for the hidden window. }
procedure TTimer.WndProc(var Msg: TMessage);
begin
  with Msg do
    if Msg = WM_TIMER then { check for timer messages }
      try
        Timer; { this calls the OnTimer event handler }
      except
        Application.HandleException(Self);
      end
    else 
 { Any other messages are passed to DefWindowProc, which tells Windows to handle the message. Note that the first parameter, FWindowHandle, is the handle of the window receiving this message. It is obtained from the call to AllocateHWnd in the constructor. }
      Result := DefWindowProc(FWindowHandle, Msg, wParam, lParam);
end;
{ The TTimer constructor uses AllocateHWnd to create the window and save its handle. } 
constructor TTimer.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  FEnabled := True;
  FInterval := 1000;
  FWindowHandle := AllocateHWnd(WndProc);
end;

{ The TTimer destructor calls DeallocateHWnd to free the hidden window. } 
destructor TTimer.Destroy;
begin
  FEnabled := False;
  UpdateTimer;
  DeallocateHWnd(FWindowHandle);
  inherited Destroy;
end; 
