
(*
 Delphi Object and Component Reference
#{bmc bm10.BMP} TToolButton, TToolBar, StringList example
To use this example, create a new application and add the example code to the unit.
*) 
procedure AddButtons(ToolBar: TToolBar;
  Const ButtonCaptions: array of String);
var
  I: Integer;
begin
  for I := 0 to High(ButtonCaptions) do
    begin
      with TToolButton.Create(ToolBar) do
      begin
        Parent := ToolBar;
        Caption := ButtonCaptions[I];
        if (ButtonCaptions[I] = '|') then
          Style := tbsSeparator
        else
          Style := tbsButton;
      end;
    end;
end;

procedure TForm1.FormCreate(Sender: TObject);
var
  ToolBar: TToolBar;
begin
  ToolBar := TToolBar.Create(Self);
  ToolBar.Parent := Self;
  AddButtons(ToolBar, ['New', 'Save', '|', 'Cut', 'Copy', 'Paste']);
  ToolBar.ShowCaptions := True;
  ToolBar.Height := 40;
end;
 
