unit TTreeCustomSort;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Forms, Dialogs,
  Menus, Controls, StdCtrls, ComCtrls;

type
  TForm1 = class(TForm)
    TreeView1: TTreeView;
    Button1: TButton;
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: TTreeCustomSort
// Method: ComCtrls.TCustomTreeView.CustomSort

// BeginCode
{
This example shows how to use the CustomSort method to order
a tree view in case-insensitive alphabetical order (either
forward or backward). The application must provide a
callback function such as CompareFunc below, which calls the
global AnsiStrIComp function to perform the actual
comparison.  This example requires a button and a populated
TreeView.
}
function CustomSortProc(Node1, Node2: TTreeNode; Data: Integer): Integer; stdcall;
begin
  Result := -AnsiStrIComp(PChar(Node1.Text), PChar(Node2.Text));
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  TreeView1.CustomSort(@CustomSortProc, 0);
end;
// EndCode
// EndExample: TTreeCustomSort
end.

